#include<cstdio>
#include<cstring>
#include<algorithm>
#include<iostream>
#include<cmath>
#include<set>
#include<vector>
#include<ctime>
#include<random>
using namespace std;
const int N = 4336; // number of demands
const int dim = 2; // dimension
double cost = 0;  // total cost
double follow_cost = 0;
double delta[11];
double pr[11];
const double eps = 1e-7; 
struct demand {
	double x[dim + 1];
	double c;
	double r;
}D[N + 1], P[N + 1];
vector<demand> Fset[10]; //Fset[i] stores all the facility which can be opened with cost in [2^{i-1}, 2^{i}), Fset[0] stores all the opened facility
vector<demand> follow; // the set of open facility in follow prediction algorithm
default_random_engine e;
uniform_real_distribution<double> u(0,1); 

inline double dist(demand &d1, demand &d2) {
	double ret = 0;
	for (int i = 1; i <= dim; i++)
		ret += (d1.x[i] - d2.x[i]) * (d1.x[i] - d2.x[i]);
	return sqrt(ret);
}

inline double open(demand &d, int level, bool flag) {
	int pos = 0;
	for (int j = 1; j < Fset[level].size(); j++) 
		if (dist(d, Fset[level][j]) < dist(d, Fset[level][0])) 
			pos = j;
	if (flag)
		Fset[0].push_back(Fset[level][pos]);
	return Fset[level][pos].c;
}

inline bool check(demand &d, vector<demand> &S) { // check whether facility d opened in set S
	int siz = S.size();
	for (int i = 0; i < siz; i++) {
		bool flag = 1;
		for (int j = 1; j <= dim; j++) 
			if (fabs(S[i].x[j] - d.x[j]) > eps) {
				flag = 0;
				break;
			}
		if (flag) 
			return 1;
	}
	return 0;
}

const bool cmp(demand &d1, demand &d2) {
	return d1.r < d2.r;
}

double getdist(demand &d, vector<demand> &S) {
	int siz = S.size();
	double ret = 1e9;
	for (int i = 0; i < siz; i++) 
		ret = min(ret, dist(d, S[i]));
	return ret;
}

double Meyerson(demand &d, bool real) {
	double retcost = 0;
	delta[0] = 1e9;
	for (int j = 0; j < Fset[0].size(); j++)
		delta[0] = min(delta[0], dist(Fset[0][j], d));
	for (int j = 1; j < 10; j++) {
		delta[j] = delta[j - 1];
		for (int k = 0; k < Fset[j].size(); k++)
			delta[j] = min(delta[j], dist(Fset[j][k], d));
	}
	int w = 1;
	for (int j = 1; j < 10; j++) {
		pr[j] = (delta[j - 1] - delta[j]) / w;
		w = w * 2;
	}
	double r = u(e);
	double sum = 0;
	bool flag = 0;
	for (int j = 9; j >= 1; j--) {
		sum = sum + pr[j];
		if (r <= sum) {
			retcost += open(d, j, real);
			flag = 1;
			retcost += delta[j];
			break;
		} 
	}
	if (!flag) 
		retcost += delta[0];
	return retcost;
}

void BuildPred(double quota, demand &p) {
	//puts("4");
	demand tmp[N + 1];
//	puts("4.1");
	while (quota > 0) {
		for (int i = 1; i <= N; i++) {
			tmp[i] = D[i];
			tmp[i].r = dist(p, D[i]);
		}
		sort(tmp + 1, tmp + N + 1, cmp);
		double len = getdist(p, Fset[0]) / 2;
		if (len < tmp[1].r) 
			return;
		for (int i = 2; i <= N; i++) 
			tmp[i].c = min(tmp[i - 1].c, tmp[i].c);
		int pos1, pos2;
		for (int i = 1; i <= N; i++) 
			if (tmp[i].r <= len) 
				pos1 = i;
		double w = 1;
		while (2 * w <= tmp[pos1].c) 
			w = w * 2;
		pos2 = pos1;
		for (int i = pos2; i >= 1; i--) {
			if (tmp[i].c >= w / 2)
				pos2 = i;
		}
		if (tmp[pos2].c <= quota) {
			Fset[0].push_back(tmp[pos2]);
			quota = quota - tmp[pos2].c;
		}
		else {
			double r = u(e);
			if (r * tmp[pos2].c <= quota) 
				Fset[0].push_back(tmp[pos2]);
			break;
		}
	}
} 

int main() {
	freopen("nonuniform.txt", "r", stdin);
	for (int i = 1; i <= N; i++) {
		for (int j = 1; j <= dim; j++)
			scanf("%lf", &D[i].x[j]);
		scanf("%lf", &D[i].c);
		int w = 1;
		for (int j = 0; j < 10; j++)
			if (D[i].c >= w && D[i].c < 2 * w) {
				Fset[j + 1].push_back(D[i]);  
				break;
			}
	}
	freopen("nonuniform_predict.txt", "r", stdin);
	for (int i = 1; i <= N; i++) {
		int pos;
		scanf("%d", &pos);
		scanf("%lf", &P[pos].c);
		for (int j = 1; j <= dim; j++)
			scanf("%lf", &P[pos].x[j]);
	}
	for (int i = 1; i <= N; i++) {
		follow_cost += dist(D[i], P[i]);
		if (!check(P[i], follow)) {
			follow.push_back(P[i]);
			follow_cost += P[i].c;
		}
	}
	printf("%lf\n", follow_cost);
	for (int cnt = 1; cnt <= 10; cnt++) {
		e.seed(time(0));
		Fset[0].clear();
		for (int i = 1; i <= N; i++) {
			double ret = Meyerson(D[i], 0);
			BuildPred(ret, P[i]);
			ret = Meyerson(D[i], 1);
			
			cost += getdist(D[i], Fset[0]);
		}
		int siz = Fset[0].size();
		for (int i = 0; i < siz; i++)
			cost += Fset[0][i].c;
	}
	printf("%lf\n", cost / 10);
}